/*
 * hex2byte.c - converts ascii text file of hex bytes back into a binary file
 *
 * @version 2005.10.17
 * @author Andrew M
 */

#include <stdio.h>
#include <fcntl.h>

void usage()
{
    printf("usage: hex2byte <infile >outfile\n");
    return;
}

void do_file(FILE *in, FILE *out)
{
	int curlen = 0;
	int current = 0;
	unsigned char ch;

    while (!feof(in))
    {
        fread(&ch, 1, 1, in);
		if (ch >= '0' && ch <= '9')
		{
			curlen++;
			current = current * 16 + ch - '0';
		}
		else if (ch >= 'A' && ch <= 'F')
		{
			curlen++;
			current = current * 16 + ch - 'A' + 10;
		}
		else if (ch >= 'a' && ch <= 'f')
		{
			curlen++;
			current = current * 16 + ch - 'a' + 10;
		}
		else
		{
			if (curlen > 0)
			{
				ch = (unsigned char)current;
				fwrite(&ch, 1, 1, out);
				current = curlen = 0;
			}
		}

		if (curlen == 2)
		{
			ch = (unsigned char)current;
			fwrite(&ch, 1, 1, out);
			current = curlen = 0;
		}
    }
}

int main(int argc, char *argv[])
{
	setmode(fileno(stdout), O_BINARY);
	setmode(fileno(stdin), O_BINARY);
	do_file(stdin, stdout);
    return 0;
}
